/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2.generator;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Set;
import net.fabricmc.fabric.api.biome.v1.NetherBiomes;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6544;
import net.minecraft.class_6880;
import net.minecraft.class_6903;
import net.minecraft.class_6908;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.api.v2.generator.BCLBiomeSource;
import org.betterx.bclib.api.v2.generator.BiomePicker;
import org.betterx.bclib.api.v2.generator.config.BCLNetherBiomeSourceConfig;
import org.betterx.bclib.api.v2.generator.config.MapBuilderFunction;
import org.betterx.bclib.api.v2.generator.map.MapStack;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiome;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiomeRegistry;
import org.betterx.bclib.api.v2.levelgen.biomes.BiomeAPI;
import org.betterx.bclib.api.v2.levelgen.biomes.InternalBiomeAPI;
import org.betterx.bclib.config.Configs;
import org.betterx.bclib.interfaces.BiomeMap;
import org.betterx.worlds.together.biomesource.BiomeSourceWithConfig;
import org.betterx.worlds.together.biomesource.ReloadableBiomeSource;

public class BCLibNetherBiomeSource
extends BCLBiomeSource
implements BiomeSourceWithConfig<BCLibNetherBiomeSource, BCLNetherBiomeSourceConfig>,
ReloadableBiomeSource {
    public static final Codec<BCLibNetherBiomeSource> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_6903.method_40419((class_5321)class_2378.field_25114).forGetter(source -> source.biomeRegistry), (App)Codec.LONG.fieldOf("seed").stable().forGetter(source -> source.currentSeed), (App)BCLNetherBiomeSourceConfig.CODEC.fieldOf("config").orElse((Object)BCLNetherBiomeSourceConfig.DEFAULT).forGetter(o -> o.config)).apply((Applicative)instance, instance.stable(BCLibNetherBiomeSource::new)));
    private BiomeMap biomeMap;
    private BiomePicker biomePicker;
    private BCLNetherBiomeSourceConfig config;

    public BCLibNetherBiomeSource(class_2378<class_1959> biomeRegistry, BCLNetherBiomeSourceConfig config) {
        this(biomeRegistry, 0L, config, false);
    }

    public BCLibNetherBiomeSource(class_2378<class_1959> biomeRegistry, long seed, BCLNetherBiomeSourceConfig config) {
        this(biomeRegistry, seed, config, true);
    }

    private BCLibNetherBiomeSource(class_2378<class_1959> biomeRegistry, long seed, BCLNetherBiomeSourceConfig config, boolean initMaps) {
        this(biomeRegistry, BCLibNetherBiomeSource.getBiomes(biomeRegistry), seed, config, initMaps);
    }

    private BCLibNetherBiomeSource(class_2378<class_1959> biomeRegistry, List<class_6880<class_1959>> list, long seed, BCLNetherBiomeSourceConfig config, boolean initMaps) {
        super(biomeRegistry, list, seed);
        this.config = config;
        this.rebuildBiomePicker();
        if (initMaps) {
            this.initMap(seed);
        }
    }

    private void rebuildBiomePicker() {
        this.biomePicker = new BiomePicker((class_2378<class_1959>)this.biomeRegistry);
        this.method_28443().forEach(biome -> {
            class_2960 biomeID = ((class_5321)biome.method_40230().orElseThrow()).method_29177();
            if (!biome.method_40227()) {
                BCLib.LOGGER.warning("Biome " + biomeID.toString() + " is requested but not yet bound.", new Object[0]);
                return;
            }
            if (!BiomeAPI.hasBiome(biomeID)) {
                BCLBiome bclBiome = new BCLBiome(biomeID, (class_1959)biome.comp_349(), BiomeAPI.BiomeType.NETHER);
                InternalBiomeAPI.registerBCLBiomeData(bclBiome);
                this.biomePicker.addBiome(bclBiome);
            } else {
                BCLBiome bclBiome = BiomeAPI.getBiome(biomeID);
                if (bclBiome != BCLBiomeRegistry.EMPTY_BIOME && bclBiome.getParentBiome() == null) {
                    this.biomePicker.addBiome(bclBiome);
                }
            }
        });
        this.biomePicker.rebuild();
    }

    @Override
    protected BCLBiomeSource cloneForDatapack(Set<class_6880<class_1959>> datapackBiomes) {
        datapackBiomes.addAll(BCLibNetherBiomeSource.getNonVanillaBiomes((class_2378<class_1959>)this.biomeRegistry));
        datapackBiomes.addAll(this.method_28443().stream().filter(h -> !((class_5321)h.method_40230().orElseThrow()).method_29177().method_12836().equals("minecraft")).toList());
        return new BCLibNetherBiomeSource((class_2378<class_1959>)this.biomeRegistry, datapackBiomes.stream().filter(b -> b.method_40222(this.biomeRegistry) && b.method_40230().orElse(null) != BCLBiomeRegistry.EMPTY_BIOME.getBiomeKey()).toList(), this.currentSeed, this.config, true);
    }

    private static List<class_6880<class_1959>> getNonVanillaBiomes(class_2378<class_1959> biomeRegistry) {
        List<String> include = Configs.BIOMES_CONFIG.getIncludeMatching(BiomeAPI.BiomeType.NETHER);
        List<String> exclude = Configs.BIOMES_CONFIG.getExcludeMatching(BiomeAPI.BiomeType.NETHER);
        return BCLibNetherBiomeSource.getBiomes(biomeRegistry, exclude, include, BCLibNetherBiomeSource::isValidNonVanillaNetherBiome);
    }

    private static List<class_6880<class_1959>> getBiomes(class_2378<class_1959> biomeRegistry) {
        List<String> include = Configs.BIOMES_CONFIG.getIncludeMatching(BiomeAPI.BiomeType.NETHER);
        List<String> exclude = Configs.BIOMES_CONFIG.getExcludeMatching(BiomeAPI.BiomeType.NETHER);
        return BCLibNetherBiomeSource.getBiomes(biomeRegistry, exclude, include, BCLibNetherBiomeSource::isValidNetherBiome);
    }

    private static boolean isValidNetherBiome(class_6880<class_1959> biome, class_2960 location) {
        return NetherBiomes.canGenerateInNether((class_5321)((class_5321)biome.method_40230().get())) || biome.method_40220(class_6908.field_36518) || BiomeAPI.wasRegisteredAsNetherBiome(location);
    }

    private static boolean isValidNonVanillaNetherBiome(class_6880<class_1959> biome, class_2960 location) {
        if (BiomeAPI.wasRegisteredAs(location, BiomeAPI.BiomeType.END_IGNORE) || ((class_5321)biome.method_40230().orElseThrow()).method_29177().method_12836().equals("minecraft")) {
            return false;
        }
        return NetherBiomes.canGenerateInNether((class_5321)((class_5321)biome.method_40230().get())) || BiomeAPI.wasRegisteredAsNetherBiome(location);
    }

    public static void register() {
        class_2378.method_10230((class_2378)class_2378.field_25096, (class_2960)BCLib.makeID("nether_biome_source"), CODEC);
    }

    public class_6880<class_1959> method_38109(int biomeX, int biomeY, int biomeZ, class_6544.class_6552 var4) {
        if (this.biomeMap == null) {
            return (class_6880)this.method_28443().stream().findFirst().get();
        }
        if ((biomeX & 0x3F) == 0 && (biomeZ & 0x3F) == 0) {
            this.biomeMap.clearCache();
        }
        BiomePicker.ActualBiome bb = this.biomeMap.getBiome(biomeX << 2, biomeY << 2, biomeZ << 2);
        return bb.biome;
    }

    protected Codec<? extends class_1966> method_28442() {
        return CODEC;
    }

    @Override
    protected void onInitMap(long seed) {
        MapBuilderFunction mapConstructor = this.config.mapVersion.mapBuilder;
        this.biomeMap = (double)this.maxHeight > (double)this.config.biomeSizeVertical * 1.5 && this.config.useVerticalBiomes ? new MapStack(seed, this.config.biomeSize, this.biomePicker, this.config.biomeSizeVertical, this.maxHeight, mapConstructor) : mapConstructor.create(seed, this.config.biomeSize, this.biomePicker);
    }

    @Override
    protected void onHeightChange(int newHeight) {
        this.initMap(this.currentSeed);
    }

    public String toString() {
        return "\nBCLib - Nether BiomeSource (" + Integer.toHexString(this.hashCode()) + ")\n    biomes     = " + this.method_28443().size() + "\n    namespaces = " + this.getNamespaces() + "\n    seed       = " + this.currentSeed + "\n    height     = " + this.maxHeight + "\n    config     = " + this.config;
    }

    @Override
    public BCLNetherBiomeSourceConfig getTogetherConfig() {
        return this.config;
    }

    @Override
    public void setTogetherConfig(BCLNetherBiomeSourceConfig newConfig) {
        this.config = newConfig;
        this.initMap(this.currentSeed);
    }

    @Override
    public void reloadBiomes() {
        this.rebuildBiomePicker();
        this.initMap(this.currentSeed);
    }
}

